// Copyright 2025 Greyscalegorilla, Inc. 

#pragma once

#include "CoreMinimal.h"
#include "GreyscalegorillaMessages.h"
#include "GreyscalegorillaMaterialImporter.generated.h"

UCLASS()
class UGreyscalegorillaMaterialDefinition : public UObject
{
	GENERATED_BODY()
public:
	class MaterialMap
	{
	public:
		const FString MapExt;
		const FString MapPath;
	};

	UPROPERTY(BlueprintReadOnly, Category = "Greyscalegorilla")
	FString MaterialPath;
	UPROPERTY(BlueprintReadOnly, Category = "Greyscalegorilla")
	FString MaterialName;
	FString SubType;
	TSharedPtr<FJsonObject> JsonObject;
	TMap<FString, TArray<MaterialMap>> Maps;
};

DECLARE_DYNAMIC_DELEGATE_OneParam(FGreyscalegorillaStringDelegate, FString, StringArg);
DECLARE_DELEGATE_OneParam(FOnMaterialErrorDelegate, FGSGConnectError);
DECLARE_DELEGATE_OneParam(FOnMaterialSuccessDelegate, FGSGConnectSuccess);

UCLASS()
class UGreyscalegorillaLibrary : public UBlueprintFunctionLibrary
{
	GENERATED_BODY()
public:
	UFUNCTION(BlueprintCallable, Category = "Greyscalegorilla")
	static TArray<UGreyscalegorillaMaterialDefinition *> GetPathsMaterials(const TArray<FString> &Paths);

	UFUNCTION(BlueprintCallable, Category = "Greyscalegorilla")
	static UMaterialInterface *AddMaterial(const UGreyscalegorillaMaterialDefinition *Definition,
										   const FGreyscalegorillaStringDelegate &CallWithAssetName);

	UFUNCTION(BlueprintCallable, Category = "Greyscalegorilla")
	static FTimerHandle SetTimerForNextTick(FTimerDynamicDelegate const &Delegate);

	UFUNCTION(BlueprintCallable, Category = "Greyscalegorilla")
	static void RequestExit();

	static FOnMaterialErrorDelegate OnMaterialError;
	static FOnMaterialSuccessDelegate OnMaterialSuccess;
};

class FGreyscalegorillaMaterialImporterModule : public IModuleInterface
{
public:
	/** IModuleInterface implementation */
	virtual void StartupModule() override;
	virtual void ShutdownModule() override;

	/** This function will be bound to Command. */
	void PluginButtonClicked() const;

private:
private:
	TSharedPtr<class FUICommandList> PluginCommands;
};

UMaterialInterface *ImportGlobalMaterial(const UGreyscalegorillaMaterialDefinition &Definition, const TFunction<void(const FString &)> &CallWithAssetName);
